/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.ButterflyAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.GeneBase;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyRoot;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public abstract class ButterflySpecies
extends GeneBase
implements IAlleleButterflySpecies {
    protected final Random rand = new Random();
    private static final IButterflyRoot butterflyRoot = ReikaBeeHelper.getButterflyRoot();
    private final IClassification branch;
    private final String scientific;
    private final String creator;
    private boolean isRegistered = false;
    private final IAllele[] template = new IAllele[EnumButterflyChromosome.values().length];
    private final HashMap<ItemStack, Float> drops = new HashMap();
    private final HashMap<ItemStack, Float> caterpillarDrops = new HashMap();

    protected ButterflySpecies(String name, String uid, String latinName, String creator, IClassification g) {
        super(uid, name, (IChromosomeType)EnumButterflyChromosome.SPECIES);
        this.branch = g;
        this.creator = creator;
        this.scientific = latinName;
    }

    public final void register() {
        System.arraycopy(this.getSpeciesTemplate(), 0, this.template, 0, this.template.length);
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumButterflyChromosome.SPECIES});
        butterflyRoot.registerTemplate(this.template);
        this.isRegistered = true;
        this.onRegister();
    }

    protected void onRegister() {
    }

    public final void addDrop(ItemStack item, float chance) {
        this.drops.put(item, Float.valueOf(chance / 100.0f));
    }

    public final void addCaterpillarDrop(ItemStack item, float chance) {
        this.caterpillarDrops.put(item, Float.valueOf(chance / 100.0f));
    }

    public final String getBinomial() {
        return this.scientific;
    }

    public final String getAuthority() {
        return this.creator;
    }

    public final IClassification getBranch() {
        return this.branch;
    }

    public final Map<ItemStack, Float> getButterflyLoot() {
        return Collections.unmodifiableMap(this.drops);
    }

    public final Map<ItemStack, Float> getCaterpillarLoot() {
        return Collections.unmodifiableMap(this.caterpillarDrops);
    }

    public final IButterfly constructIndividual() {
        return butterflyRoot.templateAsIndividual(this.template);
    }

    public final IAlleleButterflyEffect getNoEffect() {
        return (IAlleleButterflyEffect)AlleleManager.alleleRegistry.getAllele("forestry.bfNone");
    }

    public final IAlleleFlowers getBasicFlowers() {
        return ButterflyAlleleRegistry.Flower.VANILLA.getAllele();
    }

    public abstract boolean isNocturnal();

    public abstract boolean isFireproof();

    public abstract boolean isTolerantFlyer();

    public abstract int getMetabolism();

    public abstract int getTemperatureTolerance();

    public abstract int getHumidityTolerance();

    public abstract BeeAlleleRegistry.Tolerance getHumidityToleranceDir();

    public abstract BeeAlleleRegistry.Tolerance getTemperatureToleranceDir();

    public abstract ButterflyAlleleRegistry.Speeds getSpeed();

    public abstract ButterflyAlleleRegistry.Size getSize();

    public abstract ButterflyAlleleRegistry.Fertility getFertility();

    public abstract ButterflyAlleleRegistry.Territory getTerritorySize();

    public abstract ButterflyAlleleRegistry.Life getLifespan();

    public abstract IAlleleButterflyEffect getEffect();

    public abstract IAlleleFlowers getFlowerAllele();

    protected final IAllele[] getSpeciesTemplate() {
        IAllele[] alleles = butterflyRoot.getDefaultTemplate();
        alleles[EnumButterflyChromosome.SPECIES.ordinal()] = this;
        alleles[EnumButterflyChromosome.SIZE.ordinal()] = this.getSize().getAllele();
        alleles[EnumButterflyChromosome.SPEED.ordinal()] = this.getSpeed().getAllele();
        alleles[EnumButterflyChromosome.LIFESPAN.ordinal()] = this.getLifespan().getAllele();
        alleles[EnumButterflyChromosome.METABOLISM.ordinal()] = ReikaBeeHelper.getIntegerAllele(this.getMetabolism());
        alleles[EnumButterflyChromosome.FERTILITY.ordinal()] = ReikaBeeHelper.getIntegerAllele(this.getFertility().getAllele().getValue());
        alleles[EnumButterflyChromosome.TEMPERATURE_TOLERANCE.ordinal()] = ReikaBeeHelper.getToleranceGene(this.getTemperatureToleranceDir(), this.getTemperatureTolerance());
        alleles[EnumButterflyChromosome.HUMIDITY_TOLERANCE.ordinal()] = ReikaBeeHelper.getToleranceGene(this.getHumidityToleranceDir(), this.getHumidityTolerance());
        alleles[EnumButterflyChromosome.NOCTURNAL.ordinal()] = ReikaBeeHelper.getBooleanAllele(this.isNocturnal());
        alleles[EnumButterflyChromosome.TOLERANT_FLYER.ordinal()] = ReikaBeeHelper.getBooleanAllele(this.isTolerantFlyer());
        alleles[EnumButterflyChromosome.FIRE_RESIST.ordinal()] = ReikaBeeHelper.getBooleanAllele(this.isFireproof());
        alleles[EnumButterflyChromosome.FLOWER_PROVIDER.ordinal()] = this.getFlowerAllele();
        alleles[EnumButterflyChromosome.EFFECT.ordinal()] = this.getEffect();
        return alleles;
    }

    public final IButterflyRoot getRoot() {
        return butterflyRoot;
    }

    @SideOnly(value=Side.CLIENT)
    public final IIconProvider getIconProvider() {
        return null;
    }

    public int getComplexity() {
        return 0;
    }

    public float getResearchSuitability(ItemStack is) {
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World paramWorld, GameProfile f, IIndividual paramIIndividual, int paramInt) {
        return new ItemStack[0];
    }

    public static abstract class BasicButterflySpecies
    extends ButterflySpecies {
        protected BasicButterflySpecies(String name, String uid, String latinName, String creator, IClassification g) {
            super(name, uid, latinName, creator, g);
        }

        @Override
        public boolean isNocturnal() {
            return false;
        }

        public boolean hasEffect() {
            return false;
        }

        public boolean isSecret() {
            return false;
        }

        public boolean isCounted() {
            return true;
        }

        public EnumSet<BiomeDictionary.Type> getSpawnBiomes() {
            return EnumSet.noneOf(BiomeDictionary.Type.class);
        }

        public boolean strictSpawnMatch() {
            return false;
        }

        public int getIconColour(int renderPass) {
            return 0xFFFFFF;
        }

        @Override
        public boolean isFireproof() {
            return false;
        }

        @Override
        public boolean isTolerantFlyer() {
            return false;
        }

        @Override
        public IAlleleButterflyEffect getEffect() {
            return this.getNoEffect();
        }

        @Override
        public IAlleleFlowers getFlowerAllele() {
            return this.getBasicFlowers();
        }
    }

    public static class ButterflyBranch
    implements IClassification {
        public final String displayName;
        public final String description;
        private final String uid;
        private final String latinName;

        public ButterflyBranch(String id, String n, String latin, String desc) {
            this.displayName = n;
            this.description = desc;
            this.latinName = latin;
            this.uid = id;
        }

        public final IClassification.EnumClassLevel getLevel() {
            return IClassification.EnumClassLevel.GENUS;
        }

        public final String getUID() {
            return this.uid;
        }

        public final String getName() {
            return this.displayName;
        }

        public final String getScientific() {
            return this.latinName;
        }

        public final String getDescription() {
            return this.description;
        }

        public IClassification[] getMemberGroups() {
            return new IClassification[0];
        }

        public void addMemberGroup(IClassification icl) {
        }

        public IAlleleSpecies[] getMemberSpecies() {
            return new IAlleleSpecies[0];
        }

        public void addMemberSpecies(IAlleleSpecies ias) {
        }

        public IClassification getParent() {
            return null;
        }

        public void setParent(IClassification icl) {
        }
    }
}

