/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class EnderIOFacadeHandler {
    public static final EnderIOFacadeHandler instance = new EnderIOFacadeHandler();
    private Method paintConduit;
    private Method getPaintConduit;
    private Method getPaintConduitMeta;
    private Class conduitTileClass;
    private Field facadeBlock;
    private Field facadeMeta;

    private EnderIOFacadeHandler() {
        if (ModList.ENDERIO.isLoaded()) {
            try {
                Class<?> c = Class.forName("crazypants.enderio.machine.painter.PainterUtil");
                this.paintConduit = c.getMethod("setSourceBlock", ItemStack.class, Block.class, Integer.TYPE);
                this.paintConduit.setAccessible(true);
                this.getPaintConduit = c.getMethod("getSourceBlock", ItemStack.class);
                this.getPaintConduit.setAccessible(true);
                this.getPaintConduitMeta = c.getMethod("getSourceBlockMetadata", ItemStack.class);
                this.getPaintConduitMeta.setAccessible(true);
                this.conduitTileClass = Class.forName("crazypants.enderio.conduit.TileConduitBundle");
                this.facadeBlock = this.conduitTileClass.getDeclaredField("facadeId");
                this.facadeBlock.setAccessible(true);
                this.facadeMeta = this.conduitTileClass.getDeclaredField("facadeMeta");
                this.facadeMeta.setAccessible(true);
            }
            catch (Exception e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.ENDERIO, e);
                DragonAPICore.logError("Could not load EiO facade handler!");
                e.printStackTrace();
            }
        }
    }

    public void paintConduitItem(ItemStack is, Block b, int meta) {
        try {
            this.paintConduit.invoke(null, is, b, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Block getConduitItemPaint(ItemStack is) {
        try {
            return (Block)this.getPaintConduit.invoke(null, is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Block getFacade(TileEntity te) {
        try {
            return te != null && this.conduitTileClass != null && this.conduitTileClass.isAssignableFrom(te.getClass()) ? (Block)this.facadeBlock.get(te) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getFacadeMeta(TileEntity te) {
        try {
            return te != null && this.conduitTileClass != null && this.conduitTileClass.isAssignableFrom(te.getClass()) ? this.facadeMeta.getInt(te) : 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

