/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.world.World;

public class AppEngHandler
extends ModHandlerBase {
    private static final AppEngHandler instance = new AppEngHandler();
    private ItemStack certus;
    private ItemStack chargedCertus;
    private ItemStack dust;
    private ItemStack fluix;
    private ItemStack fluixdust;
    private ItemStack silicon;
    private ItemStack basicChip;
    private ItemStack advChip;
    private ItemStack basicChipPattern;
    private ItemStack advChipPattern;
    private ItemStack siliconPress;
    private ItemStack logicPress;
    private ItemStack calcPress;
    private ItemStack engPress;
    private ItemStack goldProcessor;
    private ItemStack quartzProcessor;
    private ItemStack diamondProcessor;
    private Item cell1k;
    private Item cell4k;
    private Item cell16k;
    private Item cell64k;
    private ItemStack storage1k;
    private ItemStack storage4k;
    private ItemStack storage16k;
    private ItemStack storage64k;
    private ItemStack blankPattern;
    private Item encodedPattern;
    public final Block skystone;
    public final Block quartzGlass;
    public final Block chargedCertusOre;
    private Object itemList;
    private Object matList;
    private Object blockList;
    private Object partList;
    private Class itemClass;
    private Class matClass;
    private Class blockClass;
    private Class partClass;
    private Method itemGet;
    private Method itemstackGet;
    private Method blockGet;
    private Class placeType;
    private Method partPlace;

    private AppEngHandler() {
        Block sky = null;
        Block glass = null;
        Block ore = null;
        if (this.hasMod()) {
            try {
                this.initGetters();
                this.certus = this.getMaterial("materialCertusQuartzCrystal");
                this.chargedCertus = this.getMaterial("materialCertusQuartzCrystalCharged");
                this.dust = this.getMaterial("materialCertusQuartzDust");
                this.fluix = this.getMaterial("materialFluixCrystal");
                this.fluixdust = this.getMaterial("materialFluixDust");
                this.silicon = this.getMaterial("materialSilicon");
                this.basicChip = this.getMaterial("materialBasicCard");
                this.advChip = this.getMaterial("materialAdvCard");
                this.basicChipPattern = this.getMaterial("materialBasicCard");
                this.advChipPattern = this.getMaterial("materialAdvCard");
                this.calcPress = this.getMaterial("materialCalcProcessorPress");
                this.engPress = this.getMaterial("materialEngProcessorPress");
                this.logicPress = this.getMaterial("materialLogicProcessorPress");
                this.siliconPress = this.getMaterial("materialSiliconPress");
                this.goldProcessor = this.getMaterial("materialLogicProcessor");
                this.quartzProcessor = this.getMaterial("materialCalcProcessor");
                this.diamondProcessor = this.getMaterial("materialEngProcessor");
                sky = this.getBlock("blockSkyStone");
                glass = this.getBlock("blockQuartzGlass");
                ore = this.getBlock("blockQuartzOreCharged");
                this.cell1k = this.getItem("itemCell1k");
                this.cell4k = this.getItem("itemCell4k");
                this.cell16k = this.getItem("itemCell16k");
                this.cell64k = this.getItem("itemCell64k");
                this.storage1k = this.getMaterial("materialCell1kPart");
                this.storage4k = this.getMaterial("materialCell4kPart");
                this.storage16k = this.getMaterial("materialCell16kPart");
                this.storage64k = this.getMaterial("materialCell64kPart");
                this.blankPattern = this.getMaterial("materialBlankPattern");
                this.encodedPattern = this.getItem("itemEncodedPattern");
                Class<?> c = Class.forName("appeng.parts.PartPlacement");
                this.placeType = Class.forName("appeng.parts.PartPlacement$PlaceType");
                this.partPlace = c.getDeclaredMethod("place", ItemStack.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, EntityPlayer.class, World.class, this.placeType, Integer.TYPE);
            }
            catch (Exception e) {
                DragonAPICore.logError("Cannot read AE class contents!");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.skystone = sky;
        this.quartzGlass = glass;
        this.chargedCertusOre = ore;
    }

    private void initGetters() throws Exception {
        Class<?> ae = Class.forName("appeng.core.Api", false, (ClassLoader)Launch.classLoader);
        Object inst = this.getInstance(ae);
        Field b = ae.getDeclaredField("blocks");
        Field i = ae.getDeclaredField("items");
        Field p = ae.getDeclaredField("parts");
        Field m = ae.getDeclaredField("materials");
        b.setAccessible(true);
        i.setAccessible(true);
        p.setAccessible(true);
        m.setAccessible(true);
        this.partList = p.get(inst);
        this.itemList = i.get(inst);
        this.blockList = b.get(inst);
        this.matList = m.get(inst);
        Class<?> def = Class.forName("appeng.api.util.AEItemDefinition");
        this.itemGet = def.getMethod("item", new Class[0]);
        this.blockGet = def.getMethod("block", new Class[0]);
        this.itemstackGet = def.getMethod("stack", Integer.TYPE);
        this.partClass = Class.forName("appeng.api.definitions.Parts");
        this.itemClass = Class.forName("appeng.api.definitions.Items");
        this.blockClass = Class.forName("appeng.api.definitions.Blocks");
        this.matClass = Class.forName("appeng.api.definitions.Materials");
    }

    private Object getInstance(Class ae) throws Exception {
        String[] f = new String[]{"instance", "INSTANCE", "Instance"};
        Field instance = null;
        for (int i = 0; i < f.length; ++i) {
            try {
                instance = ae.getField(f[i]);
                if (instance == null) continue;
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (instance == null) {
            throw new NoSuchFieldException("AE API Instance field not found!");
        }
        Object inst = instance.get(null);
        if (inst == null) {
            throw new NullPointerException("Instance field found but was empty!");
        }
        return inst;
    }

    private Block getBlock(String field) throws Exception {
        Field f = this.blockClass.getField(field);
        Object def = f.get(this.blockList);
        return (Block)this.blockGet.invoke(def, new Object[0]);
    }

    private Item getItem(String field) throws Exception {
        Field f = this.itemClass.getField(field);
        Object def = f.get(this.itemList);
        return (Item)this.itemGet.invoke(def, new Object[0]);
    }

    private ItemStack getMaterial(String field) throws Exception {
        Field f = this.matClass.getField(field);
        Object def = f.get(this.matList);
        return (ItemStack)this.itemstackGet.invoke(def, 1);
    }

    private ItemStack getPart(String field) throws Exception {
        Field f = this.partClass.getField(field);
        Object def = f.get(this.partList);
        return (ItemStack)this.itemstackGet.invoke(def, 1);
    }

    public static AppEngHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.certus != null && this.dust != null && this.skystone != null;
    }

    @Override
    public ModList getMod() {
        return ModList.APPENG;
    }

    public ItemStack getCertusQuartz() {
        return this.certus != null ? this.certus.func_77946_l() : null;
    }

    public ItemStack getChargedCertusQuartz() {
        return this.chargedCertus != null ? this.chargedCertus.func_77946_l() : null;
    }

    public ItemStack getCertusQuartzDust() {
        return this.dust != null ? this.dust.func_77946_l() : null;
    }

    public ItemStack getFluixCrystal() {
        return this.fluix != null ? this.fluix.func_77946_l() : null;
    }

    public ItemStack getFluixDust() {
        return this.fluixdust != null ? this.fluixdust.func_77946_l() : null;
    }

    public Collection<ItemStack> getPossibleMeteorChestLoot() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        li.add(this.calcPress);
        li.add(this.engPress);
        li.add(this.logicPress);
        li.add(this.siliconPress);
        return li;
    }

    public Collection<ItemStack> getMeteorChestLoot() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        int n = 1 + this.rand.nextInt(3);
        block6: for (int i = 0; i < n; ++i) {
            switch (this.rand.nextInt(4)) {
                case 0: {
                    li.add(this.calcPress);
                    continue block6;
                }
                case 1: {
                    li.add(this.engPress);
                    continue block6;
                }
                case 2: {
                    li.add(this.logicPress);
                    continue block6;
                }
                case 3: {
                    li.add(this.siliconPress);
                }
            }
        }
        return li;
    }

    public ItemStack getSiliconPress() {
        return this.siliconPress != null ? this.siliconPress.func_77946_l() : null;
    }

    public ItemStack getLogicPress() {
        return this.logicPress != null ? this.logicPress.func_77946_l() : null;
    }

    public ItemStack getCalcPress() {
        return this.calcPress != null ? this.calcPress.func_77946_l() : null;
    }

    public ItemStack getEngPress() {
        return this.engPress != null ? this.engPress.func_77946_l() : null;
    }

    public ItemStack getBasicChipPattern() {
        return this.basicChipPattern != null ? this.basicChipPattern.func_77946_l() : null;
    }

    public ItemStack getAdvancedChipPattern() {
        return this.advChipPattern != null ? this.advChipPattern.func_77946_l() : null;
    }

    public ItemStack getSilicon() {
        return this.silicon != null ? this.silicon.func_77946_l() : null;
    }

    public ItemStack getGoldProcessor() {
        return this.goldProcessor != null ? this.goldProcessor.func_77946_l() : null;
    }

    public ItemStack getQuartzProcessor() {
        return this.quartzProcessor != null ? this.quartzProcessor.func_77946_l() : null;
    }

    public ItemStack getDiamondProcessor() {
        return this.diamondProcessor != null ? this.diamondProcessor.func_77946_l() : null;
    }

    public Item get1KCell() {
        return this.cell1k;
    }

    public Item get4KCell() {
        return this.cell4k;
    }

    public Item get16KCell() {
        return this.cell16k;
    }

    public Item get64KCell() {
        return this.cell64k;
    }

    public ItemStack get1KStorage() {
        return this.storage1k != null ? this.storage1k.func_77946_l() : null;
    }

    public ItemStack get4KStorage() {
        return this.storage4k != null ? this.storage4k.func_77946_l() : null;
    }

    public ItemStack get16KStorage() {
        return this.storage16k != null ? this.storage16k.func_77946_l() : null;
    }

    public ItemStack get64KStorage() {
        return this.storage64k != null ? this.storage64k.func_77946_l() : null;
    }

    public ItemStack getBlankPattern() {
        return this.blankPattern != null ? this.blankPattern.func_77946_l() : null;
    }

    public Item getEncodedPattern() {
        return this.encodedPattern;
    }

    public boolean tryRightClick(ItemStack is, int x, int y, int z, int sideHit, EntityPlayer player, World world, int depth) {
        try {
            return (Boolean)this.partPlace.invoke(null, is, x, y, z, sideHit, player, world, Enum.valueOf(this.placeType, "INTERACT_FIRST_PASS"), depth);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

