/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BerryBushHandler
extends CropHandlerBase {
    private static final BerryBushHandler instance = new BerryBushHandler();
    public final Block bushID;
    public final Item berryID;
    public final Block netherBushID;
    public final Item netherBerryID;

    private BerryBushHandler() {
        Block idbush = null;
        Item idberry = null;
        Block idnetherbush = null;
        Item idnetherberry = null;
        if (this.hasMod()) {
            Class blocks = this.getMod().getBlockClass();
            Class items = this.getMod().getItemClass();
            try {
                Item netherberry;
                Item berry;
                Block netherbush;
                Block bush;
                Field f = blocks.getField("berryBush");
                idbush = bush = (Block)f.get(null);
                f = blocks.getField("netherBerryBush");
                idnetherbush = netherbush = (Block)f.get(null);
                f = items.getField("berryItem");
                idberry = berry = (Item)f.get(null);
                f = items.getField("netherBerryItem");
                idnetherberry = netherberry = (Item)f.get(null);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.berryID = idberry;
        this.bushID = idbush;
        this.netherBerryID = idnetherberry;
        this.netherBushID = idnetherbush;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return id == this.bushID || id == this.netherBushID;
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return false;
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        return this.isCrop(b, meta = world.func_72805_g(x, y, z)) && meta >= 12;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int base = meta % 4;
        int metato = 12 + base;
        world.func_72921_c(x, y, z, metato, 3);
    }

    public static BerryBushHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.bushID != null && this.berryID != null && this.netherBushID != null && this.netherBerryID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.NATURA;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) - 4;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (id == this.bushID) {
            li.add(new ItemStack(this.berryID, 1, meta - 12));
        } else if (id == this.netherBushID) {
            li.add(new ItemStack(this.netherBerryID, 1, meta - 12));
        }
        return li;
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) % 4;
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return true;
    }

    @Override
    public boolean isTileEntity() {
        return false;
    }
}

