/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class DartOreHandler
extends ModHandlerBase {
    private static final DartOreHandler instance = new DartOreHandler();
    public final Block oreID;
    public final Item gemID;
    private final ItemStack oreItem;
    private final ItemStack gemItem;
    private boolean isOreDict = false;

    private DartOreHandler() {
        Item idgem = null;
        Block idore = null;
        if (this.hasMod()) {
            try {
                Block powerOre;
                Class block = this.getMod().getBlockClass();
                Class<?> item = Class.forName("bluedart.Items.DartItem");
                Field ore = block.getField("powerOre");
                idore = powerOre = (Block)ore.get(null);
                idgem = GameRegistry.findItemStack((String)"DartCraft", (String)"Items.gemForce", (int)1).func_77973_b();
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError("DartCraft Item class not found! Cannot read its items!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.gemID = idgem;
        this.gemItem = new ItemStack(this.gemID, 1, 0);
        this.oreID = idore;
        this.oreItem = new ItemStack(this.oreID, 1, 0);
    }

    public static DartOreHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.gemID != null && this.oreID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.DARTCRAFT;
    }

    public ItemStack getOre() {
        if (!this.initializedProperly()) {
            return null;
        }
        return this.oreItem.func_77946_l();
    }

    public ItemStack getForceGem() {
        if (!this.initializedProperly()) {
            return null;
        }
        return this.gemItem.func_77946_l();
    }

    public boolean isDartOre(ItemStack block) {
        if (!this.initializedProperly()) {
            return false;
        }
        return ReikaItemHelper.matchStackWithBlock(block, this.oreID);
    }

    public void forceOreRegistration() {
        if (!this.isOreDict) {
            ItemStack overworld = new ItemStack(this.oreID, 1, 0);
            ItemStack nether = new ItemStack(this.oreID, 1, 1);
            OreDictionary.registerOre((String)ModOreList.FORCE.getOreDictNames()[0], (ItemStack)overworld);
            OreDictionary.registerOre((String)ModOreList.FORCE.getOreDictNames()[0], (ItemStack)nether);
            ModOreList.FORCE.initialize();
            DragonAPICore.log("Power ore registered to ore dictionary!");
            this.isOreDict = true;
        } else {
            DragonAPICore.logError("Power ore already registered to ore dictionary! No action taken!");
            ReikaJavaLibrary.dumpStack();
        }
    }
}

