/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class HardOresHandler {
    public static final HardOresHandler instance = new HardOresHandler();
    private static final String MODID = "harderores";
    private final HashMap<KeyedItemStack, ItemStack> oreMap = new HashMap();

    private HardOresHandler() {
    }

    public boolean isLoaded() {
        return Loader.isModLoaded((String)MODID);
    }

    private OreType findBaseOreType(ItemStack is) {
        if (!this.isLoaded()) {
            return null;
        }
        String base = this.findHardOreKey(is);
        Enum ret = null;
        if (base != null && (ret = ReikaOreHelper.getEntryFromOreName(base)) == null) {
            ret = ModOreList.getByOreName(base);
        }
        return ret;
    }

    private String findHardOreKey(ItemStack is) {
        String mod = ReikaItemHelper.getRegistrantMod(is);
        if (mod == null || !mod.equals(MODID)) {
            return null;
        }
        HashSet<String> ores = ReikaItemHelper.getOreNames(is);
        for (String s : ores) {
            if (!s.endsWith("Hard")) continue;
            return s;
        }
        return null;
    }

    public ArrayList<ItemStack> getAllHardOres() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Map.Entry<KeyedItemStack, ItemStack> ks : this.oreMap.entrySet()) {
            if (ks.getValue() == null) continue;
            ret.add(ks.getKey().getItemStack());
        }
        return ret;
    }

    public ItemStack getRootOre(ItemStack is) {
        KeyedItemStack ks = this.key(is);
        if (this.oreMap.containsKey(ks)) {
            return this.oreMap.get(ks);
        }
        OreType ore = this.findBaseOreType(is);
        this.oreMap.put(ks, ore != null ? ore.getFirstOreBlock() : null);
        return null;
    }

    private KeyedItemStack key(ItemStack is) {
        return new KeyedItemStack(is).setIgnoreNBT(true).setIgnoreMetadata(false).setSized(false).setSimpleHash(true).lock();
    }

    public Collection<ItemStack> getOresWithHardVersions() {
        return ReikaItemHelper.cloneItemCollection(this.oreMap.values());
    }

    public int getYield(ItemStack is) {
        return 1 + is.func_77960_j() % 16;
    }
}

