/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.ModInteract.ItemHandlers.HexcraftHandler;
import Reika.DragonAPI.ModList;
import com.celestek.hexcraft.api.HexColor;
import com.celestek.hexcraft.api.HexVariant;
import com.celestek.hexcraft.api.IBlockHexColorDynamic;
import com.celestek.hexcraft.api.IBlockHexColorSimple;
import com.celestek.hexcraft.api.IBlockHexVariantDynamic;
import com.celestek.hexcraft.api.IBlockHexVariantSimple;
import com.celestek.hexcraft.api.WorldGenColors;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class HexBlockHandler
extends ModHandlerBase
implements HexcraftHandler.HexHandler {
    private static final HexBlockHandler instance = new HexBlockHandler();
    private Class monolithBaseClass;
    private Class worldGenClass;
    private Class colorizedSimpleInterface;
    private Class variantSimpleInterface;

    private HexBlockHandler() {
        if (this.hasMod()) {
            try {
                WorldGenColors[] list = WorldGenColors.getList();
                Class items = this.getMod().getItemClass();
                for (BasicHexColors hex : BasicHexColors.values()) {
                    Field item = items.getField("itemHexoriumCrystal" + ReikaStringParser.capFirstChar(hex.name()));
                    item.setAccessible(true);
                    hex.crystal = (Item)item.get(null);
                    BasicHexColors.lookup.put(hex.crystal, hex);
                    hex.color = list[hex.ordinal()];
                    BasicHexColors.lookup.put(Item.func_150898_a((Block)hex.color.getMonolithBlock(false)), hex);
                    BasicHexColors.lookup.put(Item.func_150898_a((Block)hex.color.getMonolithBlock(true)), hex);
                }
                this.monolithBaseClass = Class.forName("com.celestek.hexcraft.block.base.BlockHexoriumMonolithBase");
                this.worldGenClass = Class.forName("com.celestek.hexcraft.block.BlockHexoriumMonolithWorldGen");
                this.colorizedSimpleInterface = Class.forName("com.celestek.hexcraft.api.IBlockHexColorSimple");
                this.variantSimpleInterface = Class.forName("com.celestek.hexcraft.api.IBlockHexVariantSimple");
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
            HexcraftHandler.setHandler(this);
        } else {
            this.noMod();
        }
    }

    public static HexBlockHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.monolithBaseClass != null && this.colorizedSimpleInterface != null && this.variantSimpleInterface != null;
    }

    @Override
    public ModList getMod() {
        return ModList.HEXCRAFT;
    }

    @Override
    public boolean isMonolith(Block b) {
        return this.monolithBaseClass != null && this.monolithBaseClass.isAssignableFrom(b.getClass());
    }

    @Override
    public boolean isWorldGenMonolith(Block b) {
        return this.worldGenClass != null && this.worldGenClass.isAssignableFrom(b.getClass());
    }

    public boolean isColorized(Block b) {
        return this.colorizedSimpleInterface != null && this.colorizedSimpleInterface.isAssignableFrom(b.getClass());
    }

    public boolean hasVariants(Block b) {
        return this.variantSimpleInterface != null && this.variantSimpleInterface.isAssignableFrom(b.getClass());
    }

    @SideOnly(value=Side.CLIENT)
    @DependentMethodStripper.ModDependent(value={ModList.HEXCRAFT})
    public HexColor getColor(Block b, IBlockAccess iba, int x, int y, int z) {
        if (b instanceof IBlockHexColorDynamic) {
            return ((IBlockHexColorDynamic)b).getColor(iba, x, y, z);
        }
        if (b instanceof IBlockHexColorSimple) {
            return ((IBlockHexColorSimple)b).getColor();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @DependentMethodStripper.ModDependent(value={ModList.HEXCRAFT})
    public HexVariant getVariant(Block b, IBlockAccess iba, int x, int y, int z) {
        if (b instanceof IBlockHexVariantDynamic) {
            return ((IBlockHexVariantDynamic)b).getVariant(iba, x, y, z);
        }
        if (b instanceof IBlockHexVariantSimple) {
            return ((IBlockHexVariantSimple)b).getVariant();
        }
        return null;
    }

    @Override
    public HexcraftHandler.BasicHexColor[] getColors() {
        return BasicHexColors.list;
    }

    public static enum BasicHexColors implements HexcraftHandler.BasicHexColor
    {
        RED,
        GREEN,
        BLUE,
        WHITE,
        BLACK;

        private Item crystal;
        private WorldGenColors color;
        public static final BasicHexColors[] list;
        private static final HashMap<Item, BasicHexColors> lookup;

        public WorldGenColors getValue() {
            return this.color;
        }

        @Override
        public Item getCrystal() {
            return this.crystal;
        }

        @Override
        public Block getMonolith(boolean nether) {
            return this.color.getMonolithBlock(nether);
        }

        @Override
        public boolean isPrimary(boolean nether) {
            return nether ? this == WHITE || this == BLACK : !this.isPrimary(true);
        }

        public static BasicHexColors getColorForItem(ItemStack is) {
            return lookup.get(is.func_77973_b());
        }

        static {
            list = BasicHexColors.values();
            lookup = new HashMap();
        }
    }
}

