/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.ModInteract.ItemHandlers.HexcraftHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class HexBlockHandlerSimple
extends ModHandlerBase
implements HexcraftHandler.HexHandler {
    private static final HexBlockHandlerSimple instance = new HexBlockHandlerSimple();

    private HexBlockHandlerSimple() {
        if (this.hasMod()) {
            try {
                Class items = this.getMod().getItemClass();
                for (BasicHexColors hex : BasicHexColors.values()) {
                    String key = ReikaStringParser.capFirstChar(hex.name());
                    Field item = items.getField("itemHexoriumCrystal" + key);
                    item.setAccessible(true);
                    hex.crystal = (Item)item.get(null);
                    hex.block = GameRegistry.findBlock((String)this.getMod().modLabel, (String)("blockHexoriumMonolith" + key));
                    hex.netherBlock = GameRegistry.findBlock((String)this.getMod().modLabel, (String)("blockHexoriumNetherMonolith" + key));
                    BasicHexColors.lookup.put(hex.crystal, hex);
                    BasicHexColors.lookup.put(Item.func_150898_a((Block)hex.block), hex);
                    BasicHexColors.lookup.put(Item.func_150898_a((Block)hex.netherBlock), hex);
                }
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
            HexcraftHandler.setHandler(this);
        } else {
            this.noMod();
        }
    }

    public static HexBlockHandlerSimple getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        for (BasicHexColors c : BasicHexColors.list) {
            if (c.block != null && c.netherBlock != null && c.crystal != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public ModList getMod() {
        return ModList.HEXCRAFT;
    }

    @Override
    public boolean isMonolith(Block b) {
        for (BasicHexColors c : BasicHexColors.list) {
            if (c.block != b && c.netherBlock != b) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorldGenMonolith(Block b) {
        return this.isMonolith(b);
    }

    @Override
    public HexcraftHandler.BasicHexColor[] getColors() {
        return BasicHexColors.list;
    }

    public static enum BasicHexColors implements HexcraftHandler.BasicHexColor
    {
        RED,
        GREEN,
        BLUE,
        WHITE,
        BLACK;

        private Item crystal;
        private Block block;
        private Block netherBlock;
        public static final BasicHexColors[] list;
        private static final HashMap<Item, BasicHexColors> lookup;

        @Override
        public Item getCrystal() {
            return this.crystal;
        }

        @Override
        public boolean isPrimary(boolean nether) {
            return nether ? this == WHITE || this == BLACK : !this.isPrimary(true);
        }

        @Override
        public Block getMonolith(boolean nether) {
            return nether ? this.netherBlock : this.block;
        }

        public static BasicHexColors getColorForItem(ItemStack is) {
            return lookup.get(is.func_77973_b());
        }

        static {
            list = BasicHexColors.values();
            lookup = new HashMap();
        }
    }
}

