/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Power;

import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.Power.ReikaRFHelper;

public class ReikaEUHelper {
    private static final double WATTS_PER_EU_default = 2080.0;
    private static final double WATTS_PER_EU_legacy = 22512.0;

    public static double getWattsPerEU() {
        return (double)ReikaRFHelper.getWattsPerRF() * 4.0;
    }

    public static int getIC2TierFromEUVoltage(double voltage) {
        if (IC2Handler.getInstance().isIC2Classic()) {
            return (int)Math.ceil(Math.log(voltage / 8.0) / Math.log(4.0));
        }
        if (voltage >= 8192.0) {
            return 5;
        }
        if (voltage >= 2048.0) {
            return 4;
        }
        if (voltage >= 512.0) {
            return 3;
        }
        if (voltage >= 33.0) {
            return 2;
        }
        if (voltage >= 6.0) {
            return 1;
        }
        return 0;
    }

    public static double getIC2ClassicTierVoltage(int tier) {
        return 8 << tier * 2;
    }

    public static int getIC2TierFromPower(double power) {
        return ReikaEUHelper.getIC2TierFromEUVoltage(power / ReikaEUHelper.getWattsPerEU());
    }

    public static enum Voltage {
        MICRO("mV", 0, 5),
        LOW("LV", 6, 32),
        MEDIUM("MV", 33, 511),
        HIGH("HV", 512, 2047),
        EXTREME("EV", 2048, 8191),
        ULTRA("UV", 8192, Integer.MAX_VALUE);

        public final int minVoltage;
        public final int maxVoltage;
        public final String abbrev;
        public static final Voltage[] voltages;

        private Voltage(String s, int min, int max) {
            this.minVoltage = min;
            this.maxVoltage = max;
            this.abbrev = s;
        }

        public String toString() {
            return this.abbrev + " (" + this.minVoltage + " - " + this.maxVoltage + " EU/t)";
        }

        static {
            voltages = Voltage.values();
        }
    }
}

