/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.RecipeHandlers;

import Reika.DragonAPI.Instantiable.Event.ThermalRecipeEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ThermalRecipeHelper {
    public static void addMagmaticFuel(Fluid f, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", f.getName());
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"MagmaticFuel", (NBTTagCompound)toSend);
    }

    public static void addCompressionFuel(Fluid f, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", f.getName());
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CompressionFuel", (NBTTagCompound)toSend);
    }

    public static void addCoolant(Fluid f, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", f.getName());
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"Coolant", (NBTTagCompound)toSend);
    }

    public static void addFluidTransposerFill(ItemStack in, ItemStack out, int energy, FluidStack f) {
        ThermalRecipeHelper.addFluidTransposerFill(in, out, energy, f, false);
    }

    public static void addFluidTransposerFill(ItemStack in, ItemStack out, int energy, FluidStack f, boolean reversible) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        in.func_77955_b(toSend.func_74775_l("input"));
        out.func_77955_b(toSend.func_74775_l("output"));
        toSend.func_74757_a("reversible", reversible);
        f.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerFillRecipe", (NBTTagCompound)toSend);
        ThermalRecipeHelper.fireEvent(ThermalRecipeEvent.ThermalMachine.TRANSPOSER, in, null, out, null, 0, energy);
    }

    private static void fireEvent(ThermalRecipeEvent.ThermalMachine type, ItemStack in, FluidStack out, int rf) {
        MinecraftForge.EVENT_BUS.post((Event)new ThermalRecipeEvent(type, in, out, rf));
    }

    private static void fireEvent(ThermalRecipeEvent.ThermalMachine type, ItemStack in1, ItemStack in2, ItemStack out1, ItemStack out2, int out2chance, int rf) {
        MinecraftForge.EVENT_BUS.post((Event)new ThermalRecipeEvent(type, in1, in2, out1, out2, out2chance, rf));
    }

    public static void addFluidTransposerDrain(ItemStack in, ItemStack out, int energy, FluidStack f) {
        ThermalRecipeHelper.addFluidTransposerDrain(in, out, energy, f, 100);
    }

    public static void addFluidTransposerDrain(ItemStack in, ItemStack out, int energy, FluidStack f, boolean reversible) {
        ThermalRecipeHelper.addFluidTransposerDrain(in, out, energy, f, 100, reversible);
    }

    public static void addFluidTransposerDrain(ItemStack in, ItemStack out, int energy, FluidStack f, int chance) {
        ThermalRecipeHelper.addFluidTransposerDrain(in, out, energy, f, chance, false);
    }

    public static void addFluidTransposerDrain(ItemStack in, ItemStack out, int energy, FluidStack f, int chance, boolean reversible) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        in.func_77955_b(toSend.func_74775_l("input"));
        out.func_77955_b(toSend.func_74775_l("output"));
        toSend.func_74757_a("reversible", reversible);
        toSend.func_74768_a("chance", chance);
        f.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerExtractRecipe", (NBTTagCompound)toSend);
        ThermalRecipeHelper.fireEvent(ThermalRecipeEvent.ThermalMachine.TRANSPOSER, in, null, out, null, 0, energy);
    }

    public static void addInductionSmelter(ItemStack in1, ItemStack in2, ItemStack out1, int energy) {
        ThermalRecipeHelper.addInductionSmelter(in1, in2, out1, null, energy);
    }

    public static void addInductionSmelter(ItemStack in1, ItemStack in2, ItemStack out1, ItemStack out2, int energy) {
        ThermalRecipeHelper.addInductionSmelter(in1, in2, out1, out2, 100, energy);
    }

    public static void addInductionSmelter(ItemStack in1, ItemStack in2, ItemStack out1, ItemStack out2, int out2chance, int energy) {
        ThermalRecipeHelper.addTwoInTwoOutWithChance("SmelterRecipe", in1, in2, out1, out2, out2chance, energy);
    }

    public static void addPulverizerRecipe(ItemStack in, ItemStack out1, ItemStack out2, int energy) {
        ThermalRecipeHelper.addPulverizerRecipe(in, out1, out2, 100, energy);
    }

    public static void addPulverizerRecipe(ItemStack in, ItemStack out, int energy) {
        ThermalRecipeHelper.addPulverizerRecipe(in, out, null, energy);
    }

    public static void addPulverizerRecipe(ItemStack in, ItemStack out1, ItemStack out2, int out2chance, int energy) {
        ThermalRecipeHelper.addOneInTwoOutWithChance("PulverizerRecipe", in, out1, out2, out2chance, energy);
    }

    public static void addSawmillRecipe(ItemStack in, ItemStack out1, ItemStack out2, int energy) {
        ThermalRecipeHelper.addSawmillRecipe(in, out1, out2, 100, energy);
    }

    public static void addSawmillRecipe(ItemStack in, ItemStack out, int energy) {
        ThermalRecipeHelper.addSawmillRecipe(in, out, null, energy);
    }

    public static void addSawmillRecipe(ItemStack in, ItemStack out1, ItemStack out2, int out2chance, int energy) {
        ThermalRecipeHelper.addOneInTwoOutWithChance("SawmillRecipe", in, out1, out2, out2chance, energy);
    }

    public static void addCrucibleRecipe(ItemStack in, FluidStack f, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        in.func_77955_b(toSend.func_74775_l("input"));
        f.writeToNBT(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CrucibleRecipe", (NBTTagCompound)toSend);
        ThermalRecipeHelper.fireEvent(ThermalRecipeEvent.ThermalMachine.CRUCIBLE, in, f, energy);
    }

    private static void addTwoInTwoOutWithChance(String type, ItemStack in1, ItemStack in2, ItemStack out1, ItemStack out2, int out2chance, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        if (out2 != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
        }
        in1.func_77955_b(toSend.func_74775_l("primaryInput"));
        in2.func_77955_b(toSend.func_74775_l("secondaryInput"));
        out1.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (out2 != null) {
            out2.func_77955_b(toSend.func_74775_l("secondaryOutput"));
        }
        if (out2chance < 100) {
            toSend.func_74768_a("secondaryChance", out2chance);
        }
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)type, (NBTTagCompound)toSend);
        ThermalRecipeHelper.fireEvent(ThermalRecipeEvent.ThermalMachine.getType(type), in1, in2, out1, out2, out2chance, energy);
    }

    private static void addOneInTwoOutWithChance(String type, ItemStack in, ItemStack out1, ItemStack out2, int out2chance, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        if (out2 != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
        }
        in.func_77955_b(toSend.func_74775_l("input"));
        out1.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (out2 != null) {
            out2.func_77955_b(toSend.func_74775_l("secondaryOutput"));
        }
        if (out2chance < 100) {
            toSend.func_74768_a("secondaryChance", out2chance);
        }
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)type, (NBTTagCompound)toSend);
        ThermalRecipeHelper.fireEvent(ThermalRecipeEvent.ThermalMachine.getType(type), in, null, out1, out2, out2chance, energy);
    }
}

