/*
 * Decompiled with CFR 0.152.
 */
package journeymap.shadow.io.javalin.http;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import journeymap.shadow.io.javalin.core.util.JavalinLogger;
import journeymap.shadow.io.javalin.core.util.Util;
import journeymap.shadow.io.javalin.http.Context;
import journeymap.shadow.io.javalin.http.ExceptionHandler;
import journeymap.shadow.io.javalin.http.HttpResponseException;
import journeymap.shadow.io.javalin.http.HttpResponseExceptionMapper;
import journeymap.shadow.io.javalin.http.InternalServerErrorResponse;
import journeymap.shadow.io.javalin.jetty.JettyUtil;
import journeymap.shadow.javax.servlet.http.HttpServletResponse;
import journeymap.shadow.kotlin.Metadata;
import journeymap.shadow.kotlin.jvm.internal.Intrinsics;
import journeymap.shadow.org.jetbrains.annotations.NotNull;
import journeymap.shadow.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0019J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u0006j\u0002`\u0007H\u0002R5\u0010\u0003\u001a&\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\u0010\u0012\u000e\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0018\u00010\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Ljourneymap/shadow/io/javalin/http/ExceptionMapper;", "", "()V", "handlers", "", "Ljava/lang/Class;", "Ljava/lang/Exception;", "Ljourneymap/shadow/kotlin/Exception;", "Ljourneymap/shadow/io/javalin/http/ExceptionHandler;", "getHandlers", "()Ljava/util/Map;", "handle", "", "exception", "ctx", "Ljourneymap/shadow/io/javalin/http/Context;", "handle$javalin", "handleFutureException", "", "throwable", "", "handleFutureException$javalin", "handleUnexpectedThrowable", "res", "Ljourneymap/shadow/javax/servlet/http/HttpServletResponse;", "handleUnexpectedThrowable$javalin", "noUserHandler", "", "e", "javalin"})
public final class ExceptionMapper {
    @NotNull
    private final Map<Class<? extends Exception>, ExceptionHandler<Exception>> handlers;

    public ExceptionMapper() {
        boolean bl = false;
        this.handlers = new LinkedHashMap();
    }

    @NotNull
    public final Map<Class<? extends Exception>, ExceptionHandler<Exception>> getHandlers() {
        return this.handlers;
    }

    public final void handle$javalin(@NotNull Exception exception, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter(exception, "exception");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (HttpResponseExceptionMapper.INSTANCE.canHandle(exception) && this.noUserHandler(exception)) {
            HttpResponseExceptionMapper.INSTANCE.handle(exception, ctx);
        } else {
            ExceptionHandler<Exception> exceptionHandler = Util.INSTANCE.findByClass(this.handlers, exception.getClass());
            if (exceptionHandler != null) {
                exceptionHandler.handle(exception, ctx);
            } else {
                JavalinLogger.warn("Uncaught exception", exception);
                HttpResponseExceptionMapper.INSTANCE.handle(new InternalServerErrorResponse(null, null, 3, null), ctx);
            }
        }
    }

    @Nullable
    public final Void handleFutureException$javalin(@NotNull Context ctx, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        if (throwable instanceof CompletionException && throwable.getCause() instanceof Exception) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
            }
            this.handle$javalin((Exception)throwable2, ctx);
        } else if (throwable instanceof Exception) {
            this.handle$javalin((Exception)throwable, ctx);
        }
        return null;
    }

    @Nullable
    public final Void handleUnexpectedThrowable$javalin(@NotNull HttpServletResponse res, @NotNull Throwable throwable) {
        Throwable throwable2;
        Throwable unwrapped;
        CompletionException completionException;
        Intrinsics.checkNotNullParameter(res, "res");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        CompletionException completionException2 = completionException = throwable instanceof CompletionException ? (CompletionException)throwable : null;
        Throwable throwable3 = completionException == null ? throwable : (unwrapped = (throwable2 = completionException.getCause()) == null ? throwable : throwable2);
        if (JettyUtil.INSTANCE.isClientAbortException(unwrapped) || JettyUtil.INSTANCE.isJettyTimeoutException(unwrapped)) {
            JavalinLogger.debug("Client aborted or timed out", throwable);
            return null;
        }
        res.setStatus(500);
        JavalinLogger.error("Exception occurred while servicing http-request", throwable);
        return null;
    }

    private final boolean noUserHandler(Exception e) {
        return this.handlers.get(e.getClass()) == null && this.handlers.get(HttpResponseException.class) == null;
    }
}

