/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api.utils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class GSONUtils {
    private static final ExclusionStrategy GSONStrategy = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(SkipGSON.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };
    private static final JsonSerializer<NBTTagCompound> NBTTagCompoundSerializer = (src, typeOfSrc, context) -> new JsonPrimitive(src.toString());
    private static final JsonDeserializer<NBTTagCompound> NBTTagCompoundDeserializer = (json, typeOfT, context) -> {
        try {
            if (!(json instanceof JsonPrimitive)) {
                return null;
            }
            if (!((JsonPrimitive)json).isString()) {
                return null;
            }
            return (NBTTagCompound)JsonToNBT.func_150315_a((String)json.getAsString());
        }
        catch (NBTException e) {
            throw new RuntimeException(e);
        }
    };
    public static final GsonBuilder GSON_BUILDER = new GsonBuilder().addSerializationExclusionStrategy(GSONStrategy).addDeserializationExclusionStrategy(GSONStrategy).registerTypeAdapter(NBTTagCompound.class, NBTTagCompoundDeserializer).registerTypeAdapter(NBTTagCompound.class, NBTTagCompoundSerializer).serializeNulls();
    public static final GsonBuilder GSON_BUILDER_PRETTY = new GsonBuilder().addSerializationExclusionStrategy(GSONStrategy).addDeserializationExclusionStrategy(GSONStrategy).registerTypeAdapter(NBTTagCompound.class, NBTTagCompoundDeserializer).registerTypeAdapter(NBTTagCompound.class, NBTTagCompoundSerializer).serializeNulls().setPrettyPrinting();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SkipGSON {
    }
}

