/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Base;

import Reika.ElectriCraft.Base.BlockElectriCable;
import Reika.ElectriCraft.Base.ElectriTileEntity;
import Reika.ElectriCraft.Registry.ElectriTiles;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ElectriCable
extends ElectriTileEntity {
    private boolean[] connections = new boolean[6];

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = NBT.func_74767_n("conn" + i);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        for (int i = 0; i < 6; ++i) {
            NBT.func_74757_a("conn" + i, this.connections[i]);
        }
    }

    public final boolean isConnectionValidForSide(ForgeDirection dir) {
        if (dir.offsetX == 0 && MinecraftForgeClient.getRenderPass() != 1) {
            dir = dir.getOpposite();
        }
        return this.connections[dir.ordinal()];
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public final void recomputeConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            this.connections[i] = this.isConnected(dir);
            world.func_147479_m(dx, dy, dz);
            this.onNetworkUpdate(world, x, y, z, dir);
        }
        world.func_147479_m(x, y, z);
    }

    protected void onNetworkUpdate(World world, int x, int y, int z, ForgeDirection dir) {
    }

    public final void deleteFromAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ElectriTiles m = ElectriTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != this.getTile()) continue;
            ElectriCable te = (ElectriCable)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = false;
            world.func_147479_m(dx, dy, dz);
        }
    }

    public final void addToAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ElectriTiles m = ElectriTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != this.getTile()) continue;
            ElectriCable te = (ElectriCable)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = true;
            world.func_147479_m(dx, dy, dz);
        }
    }

    private boolean isConnected(ForgeDirection dir) {
        ElectriTiles m2;
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        ElectriTiles m = this.getTile();
        return m == (m2 = ElectriTiles.getTE((IBlockAccess)this.field_145850_b, x, y, z));
    }

    public final boolean isConnectedOnSideAt(World world, int x, int y, int z, ForgeDirection dir) {
        dir = dir.offsetX == 0 ? dir.getOpposite() : dir;
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        Block b = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        if (b == this.getTileEntityBlockID()) {
            return true;
        }
        TileEntity te = world.func_147438_o(dx, dy, dz);
        return te != null && this.connectsToTile(te, dir);
    }

    public final boolean isConnectedToHandlerOnSideAt(World world, int x, int y, int z, ForgeDirection dir) {
        dir = dir.offsetX == 0 ? dir.getOpposite() : dir;
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        Block b = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        if (b == this.getTileEntityBlockID()) {
            return false;
        }
        TileEntity te = world.func_147438_o(dx, dy, dz);
        return te != null && this.connectsToTile(te, dir);
    }

    protected abstract boolean connectsToTile(TileEntity var1, ForgeDirection var2);

    public final IIcon getCenterIcon() {
        return ((BlockElectriCable)this.func_145838_q()).getCenterIcon();
    }

    public final IIcon getEndIcon() {
        return ((BlockElectriCable)this.func_145838_q()).getEndIcon();
    }
}

