/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Base;

import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.ElectriCraft.Auxiliary.Interfaces.CurrentThrottle;
import Reika.ElectriCraft.Base.TileEntityWireComponent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class TileEntityResistorBase
extends TileEntityWireComponent
implements CurrentThrottle {
    private int selectedCurrent;

    public abstract ColorBand[] getColorBands();

    protected abstract void setColorBands(ColorBand[] var1);

    @Override
    public final int getResistance() {
        return 0;
    }

    @Override
    public final int getCurrentLimit() {
        return this.selectedCurrent;
    }

    public final boolean setColor(ReikaDyeHelper color, int digit) {
        ColorBand band;
        ColorBand colorBand = band = color != null ? ColorBand.getBandFromColor(color) : null;
        if (band == null) {
            return false;
        }
        ColorBand[] bands = this.getColorBands();
        if (band.ordinal() > 7 && digit == bands.length) {
            return false;
        }
        this.assignBand(band, digit);
        this.selectedCurrent = this.calculateCurrentLimit();
        if (!this.field_145850_b.field_72995_K && this.network != null) {
            this.network.updateWires();
        }
        return true;
    }

    protected abstract int calculateCurrentLimit();

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void onNetworkChanged() {
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        ColorBand[] bands = this.getColorBands();
        for (int i = 0; i < bands.length; ++i) {
            int tag = i + 1;
            int idx = NBT.func_74762_e("band" + tag);
            bands[i] = ColorBand.bandList[idx];
        }
        this.setColorBands(bands);
        this.selectedCurrent = NBT.func_74762_e("sel");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        ColorBand[] bands = this.getColorBands();
        for (int i = 0; i < bands.length; ++i) {
            int tag = i + 1;
            NBT.func_74768_a("band" + tag, bands[i].ordinal());
        }
        NBT.func_74768_a("sel", this.selectedCurrent);
    }

    @Override
    public final float getHeight() {
        return 0.75f;
    }

    @Override
    public final float getWidth() {
        return 0.5f;
    }

    @Override
    public final boolean canConnect() {
        return this.selectedCurrent > 0;
    }

    private void assignBand(ColorBand band, int digit) {
        ColorBand[] bands = this.getColorBands();
        bands[digit - 1] = band;
        this.setColorBands(bands);
    }

    @SideOnly(value=Side.CLIENT)
    public final void setColor(ColorBand band, int digit) {
        this.assignBand(band, digit);
    }

    public static enum ColorBand {
        BLACK(ReikaDyeHelper.BLACK),
        BROWN(ReikaDyeHelper.BROWN),
        RED(ReikaDyeHelper.RED),
        ORANGE(ReikaDyeHelper.ORANGE),
        YELLOW(ReikaDyeHelper.YELLOW),
        GREEN(ReikaDyeHelper.LIME),
        BLUE(ReikaDyeHelper.BLUE),
        PURPLE(ReikaDyeHelper.PURPLE),
        GRAY(ReikaDyeHelper.GRAY),
        WHITE(ReikaDyeHelper.WHITE);

        public final ReikaDyeHelper renderColor;
        public static final ColorBand[] bandList;

        private ColorBand(ReikaDyeHelper color) {
            this.renderColor = color;
        }

        public static ColorBand getBandFromColor(ReikaDyeHelper color) {
            for (int i = 0; i < bandList.length; ++i) {
                ColorBand b = bandList[i];
                if (b.renderColor != color) continue;
                return b;
            }
            return null;
        }

        static {
            bandList = ColorBand.values();
        }
    }
}

