/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Rendering.ItemSpriteSheetRenderer;
import Reika.ElectriCraft.Auxiliary.ElectriRenderList;
import Reika.ElectriCraft.Base.ElectriTERenderer;
import Reika.ElectriCraft.CableRenderer;
import Reika.ElectriCraft.ElectriCommon;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.ElectriItemRenderer;
import Reika.ElectriCraft.Registry.ElectriItems;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.ElectriCraft.Renders.BatteryRenderer;
import Reika.ElectriCraft.WireRenderer;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

@SideOnly(value=Side.CLIENT)
public class ElectriClient
extends ElectriCommon {
    private final ItemSpriteSheetRenderer items = new ItemSpriteSheetRenderer((DragonAPIMod)ElectriCraft.instance, ElectriCraft.class, "Textures/Items/items.png");
    public static final ElectriItemRenderer machineItems = new ElectriItemRenderer();
    public static WireRenderer wire;
    public static CableRenderer cable;
    public static BatteryRenderer battery;

    @Override
    public void registerSounds() {
    }

    @Override
    public void registerRenderers() {
        wireRender = RenderingRegistry.getNextAvailableRenderId();
        wire = new WireRenderer(wireRender);
        RenderingRegistry.registerBlockHandler((int)wireRender, (ISimpleBlockRenderingHandler)wire);
        cableRender = RenderingRegistry.getNextAvailableRenderId();
        cable = new CableRenderer(cableRender);
        RenderingRegistry.registerBlockHandler((int)cableRender, (ISimpleBlockRenderingHandler)cable);
        batteryRender = RenderingRegistry.getNextAvailableRenderId();
        battery = new BatteryRenderer(batteryRender);
        RenderingRegistry.registerBlockHandler((int)batteryRender, (ISimpleBlockRenderingHandler)battery);
        if (DragonOptions.NORENDERS.getState()) {
            ElectriCraft.logger.log((Object)"Disabling all machine renders for FPS and lag profiling.");
        } else {
            this.loadModels();
        }
        this.registerSpriteSheets();
    }

    @Override
    public void addArmorRenders() {
    }

    public void loadModels() {
        for (int i = 0; i < ElectriTiles.TEList.length; ++i) {
            ElectriTiles m = ElectriTiles.TEList[i];
            if (!m.hasRender()) continue;
            ElectriTERenderer render = ElectriRenderList.instantiateRenderer(m);
            ClientRegistry.bindTileEntitySpecialRenderer((Class)m.getTEClass(), (TileEntitySpecialRenderer)render);
        }
        MinecraftForgeClient.registerItemRenderer((Item)ElectriItems.PLACER.getItemInstance(), (IItemRenderer)machineItems);
        MinecraftForgeClient.registerItemRenderer((Item)ElectriItems.WIRE.getItemInstance(), (IItemRenderer)machineItems);
        MinecraftForgeClient.registerItemRenderer((Item)ElectriItems.BATTERY.getItemInstance(), (IItemRenderer)machineItems);
        MinecraftForgeClient.registerItemRenderer((Item)ElectriItems.RFBATTERY.getItemInstance(), (IItemRenderer)machineItems);
        MinecraftForgeClient.registerItemRenderer((Item)ElectriItems.EUBATTERY.getItemInstance(), (IItemRenderer)machineItems);
    }

    private void registerSpriteSheets() {
        for (int i = 0; i < ElectriItems.itemList.length; ++i) {
            ElectriItems ii = ElectriItems.itemList[i];
            if (ii.isPlacerItem()) continue;
            MinecraftForgeClient.registerItemRenderer((Item)ElectriItems.itemList[i].getItemInstance(), (IItemRenderer)this.items);
        }
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }
}

