/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.ElectriCraft.Auxiliary.Interfaces.ConversionTile;
import Reika.ElectriCraft.Base.ElectricalEmitter;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.API.Power.ShaftPowerReceiver;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGenerator
extends ElectricalEmitter
implements Screwdriverable,
ShaftPowerReceiver,
ConversionTile,
PowerSourceTracker {
    private int lastomega;
    private int lasttorque;
    protected int omega;
    protected int torque;
    protected long power;
    protected int iotick;
    private ForgeDirection facing;

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.iotick > 0) {
            this.iotick -= 8;
        }
        if (!PowerTransferHelper.checkPowerFrom((TileEntity)this, (ForgeDirection)this.getFacing())) {
            this.noInputMachine();
        }
        if (this.power == 0L || this.omega == 0 || this.torque == 0) {
            this.power = 0L;
            this.torque = 0;
            this.omega = 0;
        }
        if ((double)this.power > 4.0E8 && !world.field_72995_K) {
            this.delete();
            world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 4.0f, true, true);
        }
        if (!(world.field_72995_K || this.network == null || this.omega == this.lastomega && this.torque == this.lasttorque)) {
            this.network.updateWires();
        }
        this.lastomega = this.omega;
        this.lasttorque = this.torque;
    }

    @Override
    public final ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.EAST;
    }

    @Override
    public void setFacing(ForgeDirection dir) {
        this.facing = dir;
    }

    public final int getOmega() {
        return this.omega;
    }

    public final int getTorque() {
        return this.torque;
    }

    public final long getPower() {
        return this.power;
    }

    public final int getIORenderAlpha() {
        return this.iotick;
    }

    public final void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.facing = this.dirs[NBT.func_74762_e("face")];
        this.omega = NBT.func_74762_e("omg");
        this.torque = NBT.func_74762_e("tq");
        this.power = NBT.func_74763_f("pwr");
        this.iotick = NBT.func_74762_e("io");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("face", this.getFacing().ordinal());
        NBT.func_74768_a("omg", this.omega);
        NBT.func_74768_a("tq", this.torque);
        NBT.func_74772_a("pwr", this.power);
        NBT.func_74768_a("io", this.iotick);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public ElectriTiles getTile() {
        return ElectriTiles.GENERATOR;
    }

    @Override
    public int getGenVoltage() {
        return this.omega * 8;
    }

    @Override
    public int getGenCurrent() {
        return this.torque / 8;
    }

    @Override
    public boolean canNetworkOnSide(ForgeDirection dir) {
        return dir == this.getFacing().getOpposite();
    }

    public void setOmega(int omega) {
        this.omega = omega;
    }

    public void setTorque(int torque) {
        this.torque = torque;
    }

    public void setPower(long power) {
        this.power = power;
    }

    public boolean canReadFrom(ForgeDirection from) {
        ForgeDirection dir = this.getFacing();
        return from == dir;
    }

    public boolean isReceiving() {
        return true;
    }

    public void noInputMachine() {
        this.torque = 0;
        this.omega = 0;
        this.power = 0L;
    }

    @Override
    public boolean canEmitPowerToSide(ForgeDirection dir) {
        return this.canNetworkOnSide(dir);
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        this.incrementFacing();
        return true;
    }

    protected void incrementFacing() {
        int o = this.getFacing().ordinal();
        if (o == 5) {
            this.setFacing(this.dirs[2]);
        } else {
            this.setFacing(this.dirs[o + 1]);
        }
        this.rebuildNetwork();
    }

    @Override
    public boolean canEmitPower() {
        return true;
    }

    public int getMinTorque(int available) {
        return this.torque;
    }

    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        ForgeDirection dir = this.getFacing();
        return PowerSourceList.getAllFrom((World)this.field_145850_b, (ForgeDirection)dir, (int)(this.field_145851_c + dir.offsetX), (int)(this.field_145848_d + dir.offsetY), (int)(this.field_145849_e + dir.offsetZ), (PowerSourceTracker)this, (ShaftMerger)caller);
    }

    public int getIoOffsetX() {
        return 0;
    }

    public int getIoOffsetY() {
        return 0;
    }

    public int getIoOffsetZ() {
        return 0;
    }

    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
    }
}

