/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.World;

import Reika.DragonAPI.Interfaces.OreGenerator;
import Reika.DragonAPI.Interfaces.Registry.OreEnum;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.ElectriCraft.Registry.ElectriOres;
import Reika.ElectriCraft.World.BasicElectriOreGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class ElectriOreGenerator
implements RetroactiveGenerator {
    public static final ElectriOreGenerator instance = new ElectriOreGenerator();
    public final ArrayList<OreGenerator> generators = new ArrayList();

    private ElectriOreGenerator() {
        this.generators.add(new BasicElectriOreGenerator());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkgen, IChunkProvider provider) {
        for (int i = 0; i < ElectriOres.oreList.length; ++i) {
            ElectriOres ore = ElectriOres.oreList[i];
            if (!ore.canGenerateInChunk(world, chunkX, chunkZ)) continue;
            for (OreGenerator gen : this.generators) {
                gen.generateOre((OreEnum)ore, random, world, chunkX, chunkZ);
            }
        }
    }

    public boolean canGenerateAt(World world, int chunkX, int chunkZ) {
        return true;
    }

    public String getIDString() {
        return "ElectriCraft Ores";
    }
}

