/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.coremod;

import alexiil.mods.load.BetterLoadingScreen;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class BetterLoadingScreenTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.Minecraft")) {
            return this.transformMinecraft(basicClass);
        }
        if (transformedName.equals("cpw.mods.fml.client.SplashProgress")) {
            return this.transformSplashProgress(basicClass);
        }
        if (name.equals("com.mumfrey.liteloader.client.api.ObjectFactoryClient")) {
            return this.transformObjectFactoryClient(basicClass);
        }
        return basicClass;
    }

    private byte[] transformObjectFactoryClient(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("preBeginGame")) continue;
            m.instructions.clear();
            m.instructions.add((AbstractInsnNode)new TypeInsnNode(187, "alexiil/mods/load/LiteLoaderProgress"));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "alexiil/mods/load/LiteLoaderProgress", "<init>", "()V", false));
            m.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformSplashProgress(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("finish")) continue;
            m.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "alexiil/mods/load/ProgressDisplayer", "close", "()V", false));
        }
        ClassWriter cw = new ClassWriter(0);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformMinecraft(byte[] before) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(before);
        reader.accept((ClassVisitor)classNode, 0);
        int transformations = 0;
        for (MethodNode m : classNode.methods) {
            if ((m.name.equals("aj") || m.name.equals("loadScreen")) && m.desc.equals("()V")) {
                m.instructions.clear();
                m.instructions.add((AbstractInsnNode)new InsnNode(177));
                m.exceptions.clear();
                m.tryCatchBlocks.clear();
                m.localVariables = null;
                m.visitMaxs(0, 1);
                ++transformations;
                break;
            }
            if ((m.name.equals("ag") || m.name.equals("startGame")) && m.desc.equals("()V")) {
                for (AbstractInsnNode node : m.instructions.toArray()) {
                    if (!(node instanceof MethodInsnNode) || !((MethodInsnNode)node).owner.equals("cpw/mods/fml/client/FMLClientHandler") || !((MethodInsnNode)node).name.equals("instance")) continue;
                    m.instructions.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "alexiil/mods/load/ProgressDisplayer", "minecraftDisplayFirstProgress", "()V", false));
                    ++transformations;
                    break;
                }
            }
            for (AbstractInsnNode node : m.instructions.toArray()) {
                if (!(node instanceof MethodInsnNode) || !((MethodInsnNode)node).owner.equals("com/mumfrey/liteloader/client/gui/startup/LoadingBar")) continue;
                m.instructions.remove(node);
            }
        }
        if (transformations != 2) {
            throw new IllegalStateException("BetterLoadingScreen couldn't not transform Minecraft properly!");
        }
        ClassWriter cw = new ClassWriter(0);
        classNode.accept((ClassVisitor)cw);
        byte[] byteArray = cw.toByteArray();
        BetterLoadingScreen.log.debug("Transformed Minecraft");
        return byteArray;
    }
}

