/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.dries007.holoInventory.client.Renderer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class BlockFluidHandlerMessage
implements IMessage {
    NBTTagCompound data;

    public BlockFluidHandlerMessage(NBTTagCompound data) {
        this.data = data;
    }

    public BlockFluidHandlerMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class Handler
    implements IMessageHandler<BlockFluidHandlerMessage, IMessage> {
        public IMessage onMessage(BlockFluidHandlerMessage message, MessageContext ctx) {
            if (message == null || message.data == null || ctx.side.isServer()) {
                return null;
            }
            NBTTagList list = message.data.func_150295_c("tank", 10);
            ArrayList<FluidTankInfo> tankInfos = new ArrayList<FluidTankInfo>();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (stack == null) continue;
                tankInfos.add(new FluidTankInfo(stack, tag.func_74762_e("capacity")));
            }
            Renderer.tileFluidHandlerMap.put(message.data.func_74762_e("id"), tankInfos);
            return null;
        }
    }
}

