/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SegmentFireArch
extends SegmentBase {
    @Override
    protected void genWall(IWorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, ITheme theme, Coord origin) {
        IStair stair = theme.getPrimaryStair();
        IBlockFactory walls = theme.getPrimaryWall();
        Cardinal[] orths = Cardinal.orthogonal(dir);
        Coord start = new Coord(origin);
        start.add(dir, 3);
        Coord end = new Coord(start);
        start.add(orths[0]);
        end.add(orths[0]);
        end.add(Cardinal.UP, 2);
        end.add(dir);
        RectSolid.fill(editor, rand, start, end, walls);
        Coord cursor = new Coord(origin);
        cursor.add(dir, 2);
        stair.setOrientation(Cardinal.reverse(dir), false).set(editor, cursor);
        cursor.add(Cardinal.UP, 2);
        stair.setOrientation(Cardinal.reverse(dir), true).set(editor, cursor);
        cursor.add(Cardinal.DOWN, 2);
        cursor.add(dir);
        BlockType.get(BlockType.NETHERRACK).set(editor, cursor);
        cursor.add(Cardinal.UP);
        BlockType.get(BlockType.FIRE).set(editor, cursor);
        cursor.add(Cardinal.reverse(dir));
        BlockType.get(BlockType.IRON_BAR).set(editor, cursor);
        for (Cardinal orth : orths) {
            cursor = new Coord(origin);
            cursor.add(dir);
            cursor.add(orth);
            cursor.add(Cardinal.UP, 2);
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, cursor);
        }
    }
}

