/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public enum Door {
    IRON,
    OAK,
    BIRCH,
    SPRUCE,
    JUNGLE,
    ACACIA,
    DARKOAK;


    public static void generate(IWorldEditor editor, Coord pos, Cardinal dir, Door type) {
        Door.generate(editor, pos, dir, type, false);
    }

    public static void generate(IWorldEditor editor, Coord pos, Cardinal dir, Door type, boolean open) {
        Coord cursor = new Coord(pos);
        MetaBlock doorBase = new MetaBlock(Door.getBlockId(type), Door.getMeta(false, dir, open, false));
        doorBase.set(editor, cursor);
        cursor.add(Cardinal.UP);
        MetaBlock doorTop = new MetaBlock(Door.getBlockId(type), Door.getMeta(true, dir, open, false));
        doorTop.set(editor, cursor);
    }

    private static Block getBlockId(Door type) {
        if (type == IRON) {
            return Blocks.field_150454_av;
        }
        return Blocks.field_150466_ao;
    }

    private static int getMeta(boolean top, Cardinal dir, boolean open, boolean hingeLeft) {
        int meta = 0;
        if (top) {
            if (hingeLeft) {
                ++meta;
            }
            return meta + 8;
        }
        if (open) {
            meta += 4;
        }
        switch (dir) {
            case WEST: {
                return meta;
            }
            case NORTH: {
                return meta + 1;
            }
            case EAST: {
                return meta + 2;
            }
            case SOUTH: {
                return meta + 3;
            }
        }
        return meta;
    }
}

