/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.gui;

import codechicken.core.gui.GuiWidget;
import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Rectangle4i;
import java.awt.Dimension;
import java.awt.Rectangle;

public abstract class GuiScrollPane
extends GuiWidget {
    protected int scrollclicky = -1;
    protected float scrollpercent;
    protected int scrollmousey;
    protected float percentscrolled;
    public int marginleft;
    public int margintop;
    public int marginright;
    public int marginbottom;

    public GuiScrollPane(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void setMargins(int left, int top, int right, int bottom) {
        this.marginleft = left;
        this.margintop = top;
        this.marginright = right;
        this.marginbottom = bottom;
    }

    public Rectangle windowBounds() {
        return new Rectangle(this.x + this.marginleft, this.y + this.margintop, this.width - this.marginleft - this.marginright, this.height - this.margintop - this.marginbottom);
    }

    public abstract int contentHeight();

    public Dimension scrollbarDim() {
        int h = (int)(this.windowBounds().getHeight() / (double)this.contentHeight() * (double)this.height);
        return new Dimension(5, h > this.height ? this.height : (h < this.height / 15 ? this.height / 15 : h));
    }

    public Rectangle scrollbarBounds() {
        Dimension dim = this.scrollbarDim();
        return new Rectangle(this.x + this.width - dim.width, this.y + (int)((double)((float)(this.height - dim.height) * this.percentscrolled) + 0.4999), dim.width, dim.height);
    }

    public void scrollUp() {
        this.scroll(-5);
    }

    public void scrollDown() {
        this.scroll(5);
    }

    public void scroll(int i) {
        this.percentscrolled += (float)(i * this.height) / (float)(2 * this.contentHeight());
        this.calculatePercentScrolled();
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.scrollbarDim().height;
        if (this.isScrolling()) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        this.percentscrolled = (float)MathHelper.clip(this.percentscrolled, 0.0, 1.0);
    }

    public boolean isScrolling() {
        return this.scrollclicky >= 0;
    }

    public boolean hasScrollbar() {
        return this.contentHeight() > this.height;
    }

    public int scrollbarGuideAlignment() {
        return -1;
    }

    public void showSlot(int sloty, int slotHeight) {
        Rectangle w = this.windowBounds();
        if (sloty + slotHeight > w.y + w.height) {
            int diff = sloty - (w.y + w.height - slotHeight);
            this.percentscrolled = (float)((double)this.percentscrolled + (double)diff / (double)(this.contentHeight() - w.height));
            this.calculatePercentScrolled();
        } else if (sloty < w.y) {
            int diff = w.y - sloty;
            this.percentscrolled = (float)((double)this.percentscrolled - (double)diff / (double)(this.contentHeight() - w.height));
            this.calculatePercentScrolled();
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int button) {
        Rectangle sbar = this.scrollbarBounds();
        Rectangle w = this.windowBounds();
        int barempty = this.height - sbar.height;
        if (button == 0 && sbar.height < this.height && mx >= sbar.x && mx <= sbar.x + sbar.width && my >= this.y && my <= this.y + this.height) {
            if (my < sbar.y) {
                this.percentscrolled = (float)(my - this.y) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (my > sbar.y + sbar.height) {
                this.percentscrolled = (float)(my - this.y - sbar.height + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = my;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = my;
            }
        } else if (w.contains(mx, my)) {
            this.slotDown(mx - w.x, my - w.y + this.scrolledPixels(), button);
        }
    }

    public void slotDown(int mx, int my, int button) {
    }

    public void slotUp(int mx, int my, int button) {
    }

    @Override
    public void mouseMovedOrUp(int mx, int my, int button) {
        Rectangle w = this.windowBounds();
        if (this.isScrolling() && button == 0) {
            this.scrollclicky = -1;
        } else if (w.contains(mx, my)) {
            this.slotUp(mx - w.x, my - w.y + this.scrolledPixels(), button);
        }
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long time) {
        if (this.isScrolling()) {
            int scrolldiff = mousey - this.scrollclicky;
            int sbarh = this.scrollbarDim().height;
            int barupallowed = (int)((double)((float)(this.height - sbarh) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - sbarh - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public int scrolledPixels() {
        int scrolled = (int)((double)((float)(this.contentHeight() - this.windowBounds().height) * this.percentscrolled) + 0.5);
        if (scrolled < 0) {
            scrolled = 0;
        }
        return scrolled;
    }

    public Rectangle4i bounds() {
        return new Rectangle4i(this.x, this.y, this.width, this.height);
    }

    public boolean contains(int mx, int my) {
        return this.bounds().contains(mx, my);
    }

    @Override
    public void draw(int mx, int my, float frame) {
        Rectangle w = this.windowBounds();
        this.drawBackground(frame);
        this.drawContent(mx - w.x, my + this.scrolledPixels() - w.y, frame);
        this.drawOverlay(frame);
        this.drawScrollbar(frame);
    }

    public void drawBackground(float frame) {
        GuiScrollPane.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
    }

    public abstract void drawContent(int var1, int var2, float var3);

    public void drawOverlay(float frame) {
        GuiScrollPane.func_73734_a((int)this.x, (int)(this.y - 1), (int)(this.x + this.width), (int)this.y, (int)-6250336);
        GuiScrollPane.func_73734_a((int)this.x, (int)(this.y + this.height), (int)(this.x + this.width), (int)(this.y + this.height + 1), (int)-6250336);
        GuiScrollPane.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)this.x, (int)(this.y + this.height + 1), (int)-6250336);
        GuiScrollPane.func_73734_a((int)(this.x + this.width), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)-6250336);
    }

    public void drawScrollbar(float frame) {
        Rectangle r = this.scrollbarBounds();
        GuiScrollPane.func_73734_a((int)r.x, (int)r.y, (int)(r.x + r.width), (int)(r.y + r.height), (int)-7631989);
        GuiScrollPane.func_73734_a((int)r.x, (int)r.y, (int)(r.x + r.width - 1), (int)(r.y + r.height - 1), (int)-986896);
        GuiScrollPane.func_73734_a((int)(r.x + 1), (int)(r.y + 1), (int)(r.x + r.width), (int)(r.y + r.height), (int)-11184811);
        GuiScrollPane.func_73734_a((int)(r.x + 1), (int)(r.y + 1), (int)(r.x + r.width - 1), (int)(r.y + r.height - 1), (int)-3750202);
        int algn = this.scrollbarGuideAlignment();
        if (algn != 0) {
            GuiScrollPane.func_73734_a((int)(algn > 0 ? r.x + r.width : r.x - 1), (int)this.y, (int)r.x, (int)(this.y + this.height), (int)-8355712);
        }
    }
}

