/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class Content
implements MultiPartRegistry.IPartFactory,
MultiPartRegistry.IPartConverter {
    @Override
    public TMultiPart createPart(String name, boolean client) {
        if (name.equals("mc_torch")) {
            return new TorchPart();
        }
        if (name.equals("mc_lever")) {
            return new LeverPart();
        }
        if (name.equals("mc_button")) {
            return new ButtonPart();
        }
        if (name.equals("mc_redtorch")) {
            return new RedstoneTorchPart();
        }
        return null;
    }

    public void init() {
        MultiPartRegistry.registerConverter(this);
        MultiPartRegistry.registerParts(this, new String[]{"mc_torch", "mc_lever", "mc_button", "mc_redtorch"});
    }

    @Override
    public Iterable<Block> blockTypes() {
        return Arrays.asList(Blocks.field_150478_aa, Blocks.field_150442_at, Blocks.field_150430_aB, Blocks.field_150471_bO, Blocks.field_150429_aA, Blocks.field_150437_az);
    }

    @Override
    public TMultiPart convert(World world, BlockCoord pos) {
        Block b = world.func_147439_a(pos.x, pos.y, pos.z);
        int meta = world.func_72805_g(pos.x, pos.y, pos.z);
        if (b == Blocks.field_150478_aa) {
            return new TorchPart(meta);
        }
        if (b == Blocks.field_150442_at) {
            return new LeverPart(meta);
        }
        if (b == Blocks.field_150430_aB) {
            return new ButtonPart(meta);
        }
        if (b == Blocks.field_150471_bO) {
            return new ButtonPart(meta | 0x10);
        }
        if (b == Blocks.field_150429_aA) {
            return new RedstoneTorchPart(meta);
        }
        if (b == Blocks.field_150437_az) {
            return new RedstoneTorchPart(meta | 0x10);
        }
        return null;
    }
}

